// Assembly of machine set up to multiply 36 by 0, 1, ..., 9.
// Includes one rod for 0, one for 3, one for 6, a three-rod cradle,
// and its lid.

// Assumes that font.scad exists and that
// table.scad has been constructed for base 10.

//  David Moews, 22-VI-2014.
//  
//  This file is in the public domain.

include <font.scad>;
include <table.scad>;
include <main.scad>;

union()
{
  // 3 rods
  cradle(3);

  // Omit the following two lines to see the inside of the machine.
  color("black") embossedlidtext(3);
  basiclid(3);

  translate(v = [rodxcoord(0), clearance, r + clearance + axleclearance])
  rotate(a=[0, -9 * 360 / ncarrysymbols, 0])
  {
    basicrod();
    color("red") embossedtext(0);
  }

  translate(v = [rodxcoord(1), clearance, r + clearance + axleclearance])
  rotate(a=[0, -17 * 360 / ncarrysymbols, 0])
  {
    basicrod();
    color("red") embossedtext(3);
  }

  translate(v = [rodxcoord(2), clearance, r + clearance + axleclearance])
  {
    basicrod();
    color("red") embossedtext(6);
  }
}
